/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.BarRowItem;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.IBarRow;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.PlatformHelper;
import net.java.dev.designgridlayout.PrefWidthExtractor;
import net.java.dev.designgridlayout.Tag;

final class BarRow
extends AbstractRow
implements IBarRow {
    private final List<BarRowItem> _items = new ArrayList<BarRowItem>();
    private List<BarRowItem> _leftItems = null;
    private List<BarRowItem> _centerItems = null;
    private List<BarRowItem> _rightItems = null;
    private int _numUnrelatedGaps = 0;
    private boolean _ownRowWidth = false;
    private int _compWidth = 0;

    BarRow() {
    }

    @Override
    public IBarRow add(JComponent child, Tag tag) {
        if (child != null) {
            this._items.add(new BarRowItem(child, tag == null ? Tag.OTHER : tag));
            this.parent().add(child);
        }
        return this;
    }

    @Override
    public IBarRow center(JComponent ... children2) {
        return this.add(Tag.OTHER, children2);
    }

    @Override
    public IBarRow left(JComponent ... children2) {
        return this.add(Tag.LEFT, children2);
    }

    @Override
    public IBarRow right(JComponent ... children2) {
        return this.add(Tag.RIGHT, children2);
    }

    private IBarRow add(Tag tag, JComponent ... children2) {
        for (JComponent child : children2) {
            this.add(child, tag);
        }
        return this;
    }

    @Override
    public IBarRow gap() {
        this._items.add(null);
        return this;
    }

    @Override
    public IBarRow withOwnRowWidth() {
        this._ownRowWidth = true;
        return this;
    }

    List<BarRowItem> items() {
        if (this._leftItems == null) {
            this._leftItems = PlatformHelper.extractLeftItems(this._items);
            this._centerItems = PlatformHelper.extractCenterItems(this._items);
            this._rightItems = PlatformHelper.extractRightItems(this._items);
            this._items.clear();
            this._items.addAll(this._leftItems);
            this._items.addAll(this._centerItems);
            this._items.addAll(this._rightItems);
            this._numUnrelatedGaps = this.numGapsBetweenParts();
            Iterator<BarRowItem> i = this._items.iterator();
            while (i.hasNext()) {
                if (i.next() != null) continue;
                i.remove();
                ++this._numUnrelatedGaps;
            }
        }
        return this._items;
    }

    @Override
    int totalNonGridWidth(int hgap, int unrelhgap) {
        int leftWidth = this.computePartWidth(this._leftItems, hgap, unrelhgap);
        int rightWidth = this.computePartWidth(this._rightItems, hgap, unrelhgap);
        int centerWidth = this.computePartWidth(this._centerItems, hgap, unrelhgap);
        int sidesWidth = Math.max(leftWidth, rightWidth);
        if (centerWidth != 0 && (leftWidth != 0 || rightWidth != 0)) {
            sidesWidth *= 2;
        }
        int totalWidth = centerWidth + sidesWidth + unrelhgap * this.numGapsBetweenParts();
        return totalWidth;
    }

    @Override
    int componentNonGridWidth() {
        return this._ownRowWidth ? 0 : this.actualComponentNonGridWidth();
    }

    private int actualComponentNonGridWidth() {
        return ComponentHelper.maxValues(this._items, PrefWidthExtractor.INSTANCE);
    }

    @Override
    void forceComponentNonGridWidth(int width) {
        this._compWidth = width > 0 && !this._ownRowWidth ? width : this.actualComponentNonGridWidth();
    }

    @Override
    int layoutRow(LayoutHelper helper, int left, int hgap, int gridgap, int unrelhgap, int rowWidth, int gridsWidth, List<Integer> labelsWidth) {
        int x = left;
        int actualHeight = this.layoutOnePart(helper, x, hgap, unrelhgap, this._leftItems);
        x = left + (rowWidth - this.computePartWidth(this._centerItems, hgap, unrelhgap)) / 2;
        actualHeight = Math.max(actualHeight, this.layoutOnePart(helper, x, hgap, unrelhgap, this._centerItems));
        x = left + rowWidth - this.computePartWidth(this._rightItems, hgap, unrelhgap);
        actualHeight = Math.max(actualHeight, this.layoutOnePart(helper, x, hgap, unrelhgap, this._rightItems));
        return actualHeight;
    }

    private int computePartWidth(List<BarRowItem> items, int hgap, int unrelhgap) {
        if (!items.isEmpty()) {
            int numUnrelGaps = Collections.frequency(items, null);
            int numComponents = items.size() - numUnrelGaps;
            int numGaps = numComponents - numUnrelGaps - 1;
            int width = numComponents * this._compWidth + numGaps * hgap + numUnrelGaps * unrelhgap;
            return width;
        }
        return 0;
    }

    private int numGapsBetweenParts() {
        int numParts = (this._leftItems.isEmpty() ? 0 : 1) + (this._centerItems.isEmpty() ? 0 : 1) + (this._rightItems.isEmpty() ? 0 : 1);
        return numParts > 0 ? numParts - 1 : 0;
    }

    private int layoutOnePart(LayoutHelper helper, int xOrigin, int hgap, int unrelhgap, List<BarRowItem> items) {
        int x = xOrigin;
        int actualHeight = 0;
        for (BarRowItem item : items) {
            if (item != null) {
                actualHeight = Math.max(actualHeight, helper.setSizeLocation(item.component(), x, this._compWidth, this.height(), this.baseline()));
                x += this._compWidth + hgap;
                continue;
            }
            x += unrelhgap - hgap;
        }
        return actualHeight;
    }
}

